import { connect } from 'react-redux';
import YandexForm from './YandexForm';
import { YandexFormHost, YandexFormStateConnectedProps, YandexFormProps } from './YandexForm.types';

const mapState = (state) => ({
  host:
    state && state.root && state.root.info && state.root.info.testMode
      ? YandexFormHost.Test
      : YandexFormHost.Prod,
});

export default connect<
  YandexFormStateConnectedProps,
  {},
  Omit<YandexFormProps, keyof YandexFormStateConnectedProps>
>(mapState)(YandexForm);
