import { CSSProperties } from 'react';

export enum YandexFormHost {
  Test = 'https://forms.test.yandex-team.ru/',
  Prod = 'https://forms.yandex-team.ru/',
}

export interface YandexFormStateConnectedProps {
  host: string;
}

export type QueryObject = { [key: string]: string | number };

export interface YandexFormProps {
  style?: CSSProperties;
  name: string;
  formId: number;
  host: string;
  queryObject?: QueryObject;
  className?: string;
  onSuccess?: () => void;
  onFail?: (firstErrorPosition: number) => void;
  minHeightTrigger: number;
}

export type YandexFormLogPayload = {
  formId: number;
  values?: QueryObject;
};
