import React, { useRef, useLayoutEffect, useMemo } from 'react';
import '@doc-tools/transform/dist/css/yfm.min.css';
import '@doc-tools/transform/dist/js/yfm.min.js';
import { MagicLinks } from '@yandex-int/magiclinks';
import cx from 'classnames';
import { YfmFormatterProps } from './YfmFormatter.types';
import { wikiToHtml } from './YfmFormatter.utils';
import { useIframesResize } from './useIframesResize';
import css from './YfmFormatter.module.css';

export const YfmFormatter: React.FC<YfmFormatterProps> = ({
  markdown = '',
  className,
  onContentUpdated,
}) => {
  const containerRef = useRef<HTMLDivElement>(null);
  const magicLinks = useRef<MagicLinks>();
  const html = useMemo(() => wikiToHtml(markdown), [markdown]);

  useIframesResize({ containerRef });

  useLayoutEffect(() => {
    if (!containerRef.current || magicLinks.current) {
      return;
    }
    const element = containerRef.current;
    magicLinks.current = new MagicLinks().addConsumption(element, {
      filter: (href, url) => href.classList.contains('yfm__magiclink') || href.innerText === url,
    });

    onContentUpdated?.();
    return () => {
      magicLinks.current?.delConsumption(element);
    };
  }, []);

  return (
    <div
      className={cx('yfm', css.YfmFormatter, className)}
      ref={containerRef}
      dangerouslySetInnerHTML={{ __html: html }}
    />
  );
};
