import { wikiToMd } from '@yandex-data-ui/wiki-yfm-converter';
import transform from '@doc-tools/transform';

import color from 'markdown-it-color';
import ins from 'markdown-it-ins';
import attrs from 'markdown-it-attrs';
import sub from 'markdown-it-sub';
import mark from 'markdown-it-mark';
import code from '@doc-tools/transform/lib/plugins/code';
import cut from '@doc-tools/transform/lib/plugins/cut';
import notes from '@doc-tools/transform/lib/plugins/notes';
import tabs from '@doc-tools/transform/lib/plugins/tabs';
import imsize from '@doc-tools/transform/lib/plugins/imsize';
import sup from '@doc-tools/transform/lib/plugins/sup';
import { iframe } from '@yandex-data-ui/yfm-intranet-plugins';
import { ACTION_IFRAME, REGEXP_ACTION, REGEXP_ATTR } from './YfmFormatter.config';

export const replaceAction = (markdown: string, action: string, callback: (props: Record<string, string | undefined>) => string) => {
  return markdown.replace(REGEXP_ACTION(action), (_, ...params: string[]) => {
    const attrs = params[0]?.match(REGEXP_ATTR)?.reduce((acc, attr: string) => {
      const [key, value] = attr.split("=");
      acc[key] = value.replace(/'|"/g, "");
      return acc;
    }, {});
    return callback(attrs || {});
  });
};

export const wikiToHtml = (markdown: string) => {
  const validMarkdown = replaceAction(markdown, 'forms', ({ id }) => ACTION_IFRAME(id));

  const md = wikiToMd(validMarkdown, {
    actions: [{ name: 'iframe' }],
    enableMagicLinks: true,
  });
  const {
    result: { html },
  } = transform(md, {
    plugins: [color, ins, attrs, iframe, imsize, code, cut, sub, sup, mark, notes, tabs],
    inline: true,
    allowHtml: true,
    allowedAttributes: ['class'],
  });
  return html;
};
