import { useEffect } from 'react';
import { useIframesResizeProps } from './useIframesResize.types';

export const useIframesResize = ({ containerRef }: useIframesResizeProps) => {
  const findIframe = (frameElement) => {
    if (!containerRef.current) {
      return;
    }

    const iframeList = containerRef.current.querySelectorAll('iframe');

    for (let i = 0; i < iframeList.length; ++i) {
      if (iframeList[i].contentWindow === frameElement) {
        return iframeList[i];
      }
    }
  };

  const receiveMessage = (e) => {
    try {
      const data = JSON.parse(e.data);
      const height = data['iframe-height'];

      const iframe = findIframe(e.source);

      if (height && iframe) {
        iframe.style.height = height + 'px';
        iframe.style.minWidth = '500px';
      }
    } catch (err) {}
  };

  useEffect(() => {
    if (!containerRef.current) {
      return;
    }

    window.addEventListener('message', receiveMessage, false);

    return () => {
      window.removeEventListener('message', receiveMessage, false);
    };
  }, [containerRef]);
};
