import React, { FC, memo } from 'react';
import cx from 'classnames';
import { Box } from 'components/design/ListItem/Box';
import { Text } from 'components/design/Text';
import { LeftRight } from 'components/design/ListItem/LeftRight';
import { Check } from 'components/design/ListItem/Check';
import { LeftRightSize } from 'components/design/ListItem/LeftRight/LeftRight.types';
import { OptionProps } from './Option.types';
import css from './Option.module.css';
import { checkIconTestid } from './Option.constants';

const size: LeftRightSize = {
  ratio: {
    left: 6,
    right: 1,
  },
};
export const Option: FC<OptionProps> = memo((props) => {
  const {
    item,
    isSelected = false,
    border = 'bottom-margin',
    iconSize,
    group,
    isHovered = false,
    onMouseEnter,
    onMouseLeave,
    onClick,
  } = props;
  if (item.name == null || item.value == null) {
    return null;
  }
  const { name } = item;

  const className = cx(css.Option, {
    [css.Option_hovered]: isHovered,
  });

  return (
    <Box
      className={className}
      group={group}
      border={border}
      onClick={onClick}
      onMouseEnter={onMouseEnter}
      onMouseLeave={onMouseLeave}
      cursor="pointer"
    >
      <LeftRight
        size={size}
        left={<Text overflow="hidden">{name}</Text>}
        right={
          isSelected && (
            <Text
              align="end"
              icon={(cls) => <Check size={iconSize} className={cls} data-testid={checkIconTestid} />}
            />
          )
        }
      />
    </Box>
  );
});
