import React, { FC, memo } from 'react';
import cx from 'classnames';
import { Overlay } from 'components/Overlay';
import { Popup } from 'components/design/ListItem/Popup';
import { Group } from 'components/design/ListItem/Group';
import { NoResults } from './NoResults';
import { PopupItemsProps } from './PopupItems.types';
import { Option } from './Option';
import { defaultGetValue, propsAreEqual } from './PopupItems.utils';
import css from './PopupItems.module.css';
import { config } from 'services/Config';

export const PopupItems: FC<PopupItemsProps> = memo((props) => {
  const {
    value,
    onChange,
    onClose,
    items = [],
    isEditing,
    renderItem = Option,
    anchor,
    parentRef,
    directions,
    getValue = defaultGetValue,
    isLoading = false,
  } = props;

  const className = cx(css.PopupItems, {
    [css.PopupItems_loading]: isLoading,
  });

  const handleChange = (item: { value: number | string }) => {
    if (onChange) {
      onChange(getValue(item));
    }
  };

  return (
    <Popup
      // даем лего попапу пересчитать свое позиционирование
      // при изменении пропсов, влияющих на высоту элемента
      key={`${items.length} ${isLoading}`}
      className={className}
      visible={isEditing}
      anchor={anchor}
      onOutsideClick={onClose}
      scope={parentRef}
      role="dialog"
      directions={directions}
      continuePropagation={config.value.features.newDesignLift}
    >
      {isLoading && <Overlay display hasSpinner borderRadius={8} />}
      {!isLoading && !items.length && <NoResults />}
      {!isLoading && Boolean(items.length) && (
        <Group
          items={items}
          getValue={getValue}
          renderItem={renderItem}
          isFocused={isEditing}
          value={value}
          onChange={handleChange}
        />
      )}
    </Popup>
  );
}, propsAreEqual);
