import React from 'react';
import { render, screen } from '@testing-library/react';
import userEvent from '@testing-library/user-event';
import { Textinput } from './Textinput';

describe('Edit/Textinput', () => {
  describe('props.onChange', () => {
    it('calls on text change', () => {
      const handleChange = jest.fn();
      render(<Textinput onChange={handleChange} />);

      userEvent.type(screen.getByRole('textbox'), 'a');

      expect(handleChange).toBeCalledTimes(1);
      expect(handleChange.mock.calls[0][0]).toBe('a');
    });
  });

  describe('props.value', () => {
    it('sets value to textinput', () => {
      const value = 'test';
      render(<Textinput value={value} />);

      expect(screen.getByDisplayValue('test')).toBeInTheDocument();
    });
  });

  describe('props.placeholder', () => {
    it('sets placeholder to input', () => {
      const placeholder = 'test';
      render(<Textinput placeholder={placeholder} />);

      expect(screen.getByPlaceholderText('test')).toBeInTheDocument();
    });
  });
});
