import React, { FC, useRef, memo, KeyboardEvent } from 'react';
import LegoTextinput from '@crm/components/dist/lego2/Textinput';
import { Box } from 'components/design/ListItem/Box';
import { useFocusKeeping } from 'utils/hooks/useFocusKeeping';
import { useOutsideClick } from 'utils/hooks/useOutsideClick';
import { mergeAllRefs } from '@yandex-lego/components/lib/mergeRefs';
import { TextinputProps } from './Textinput.types';
import css from './Textinput.module.css';

export const Textinput: FC<TextinputProps> = memo((props) => {
  const { value = '', onChange, group, placeholder, nodeRef, onClose, onEnter } = props;
  const isEnterDown = useRef(false);
  const boxRef = useRef<HTMLDivElement>(null);
  const controlRef = useRef<HTMLInputElement>(null);
  useOutsideClick(boxRef, onClose);
  useFocusKeeping(controlRef);

  const handleKeyDown = (event: KeyboardEvent) => {
    isEnterDown.current = event.key === 'Enter';
  };

  const handleKeyUp = (event: KeyboardEvent) => {
    if (onEnter && isEnterDown.current && event.key === 'Enter') {
      onEnter();
      isEnterDown.current = false;
    }
  };

  return (
    <Box
      className={css.Textinput}
      border="focus"
      group={group}
      nodeRef={mergeAllRefs(boxRef, nodeRef)}
    >
      <LegoTextinput
        className={css.Textinput__control}
        placeholder={placeholder != null ? String(placeholder) : undefined}
        view="default"
        hasClear
        value={String(value)}
        onChange={onChange}
        controlRef={controlRef}
        onKeyDown={handleKeyDown}
        onKeyUp={handleKeyUp}
      />
    </Box>
  );
});
