import React, { FC, useRef } from 'react';
import { types as BoxTypes } from 'components/design/ListItem/Box';
import { Select as ReadSelect } from '../../Read/Select';
import { SelectProps } from './Select.types';
import { PopupItems } from '../../Edit/PopupItems';
import { defaultGetValue, defaultGetName } from './Select.utils';

export const Select: FC<SelectProps> = (props) => {
  const {
    access,
    value,
    items = [],
    onChange,
    isReadLoading = false,
    isEditLoading = false,
    label,
    border,
    group,
    isEditing = false,
    onEditingStart,
    onEditingStop,
    parentRef,
    size,
    getName = defaultGetName,
    getValue = defaultGetValue,
    renderItem,
    directions,
  } = props;
  const readRef = useRef<HTMLDivElement>(null);

  const readBorder: BoxTypes.BorderType | undefined = isEditing ? 'focus' : border;
  const toggleEditing = () => {
    if (isEditing) {
      onEditingStop();
    } else {
      onEditingStart();
    }
  };

  const handleChange = (value: number | string) => {
    if (onChange) {
      onChange(value);
      onEditingStop();
    }
  };

  const selectedItem = items.find((item) => getValue(item) === value);
  const previewValue = getName(selectedItem);

  return (
    <>
      <ReadSelect
        value={previewValue}
        label={label}
        onClick={toggleEditing}
        access={access}
        isLoading={isReadLoading}
        group={group}
        border={readBorder}
        nodeRef={readRef}
        size={size}
      />
      <PopupItems
        value={value}
        items={items}
        getValue={getValue}
        renderItem={renderItem}
        onChange={handleChange}
        isLoading={isEditLoading}
        parentRef={parentRef}
        isEditing={isEditing}
        anchor={readRef}
        onClose={onEditingStop}
        directions={directions}
      />
    </>
  );
};
