import { RefObject, ComponentType } from 'react';
import { RenderProps } from 'components/design/ListItem/Group';
import { ComponentCanGroupProps } from 'components/design/ListItem/Group/ComponentCanGroupProps';
import { Direction } from '@crm/components/dist/lego2/withOldDirections';
import { ReadEditProps } from '../../ReadEditProps';

export interface Option {
  value: number | string;
  name: string;
}

export interface SelectProps extends ReadEditProps, ComponentCanGroupProps {
  items: unknown[];
  renderItem?: ComponentType<RenderProps>;
  getValue?: (item: unknown) => string | number;
  getName?: (item?: unknown) => string;
  parentRef: RefObject<HTMLElement>;
  directions?: Direction[];
}
