import React, { useState, useRef } from 'react';
import { User } from 'components/design/ListItem/User';
import { SuggestUser } from 'types/SuggestUser';
import { Select as SelectComponent } from '../Select';
import css from './Stories.module.css';

export default {
  title: 'design/Attribute/ReadEdit/Select',
  component: module,
};

const useRowForSelect = () => {
  const [isEditing, setEditing] = useState(false);
  const rowRef = useRef<HTMLDivElement>(null);
  const [value, setValue] = useState<number | string>();
  const handleChange = (value: number | string) => {
    setValue(value);
  };

  const handleEditingStart = () => {
    setEditing(true);
  };

  const handleEditingStop = () => {
    setEditing(false);
  };

  return {
    onEditingStart: handleEditingStart,
    onEditingStop: handleEditingStop,
    onChange: handleChange,
    isEditing,
    value,
    rowRef,
  };
};

export const Select = () => {
  const row = useRowForSelect();
  return (
    <div className={css.Page}>
      <div className={css.Row} ref={row.rowRef}>
        <SelectComponent
          parentRef={row.rowRef}
          label="Приоритет"
          access={3}
          items={[
            {
              value: 1,
              name: 'Низкий',
            },
            {
              value: 2,
              name: 'Нормальный',
            },
            {
              value: 3,
              name: 'Высокий',
            },
            {
              value: 4,
              name: 'Очень очень очень высокий прям критикал супер важная задача asap',
            },
          ]}
          {...row}
        />
      </div>
    </div>
  );
};

export const SelectScroll = () => {
  const row = useRowForSelect();
  return (
    <div className={css.Page}>
      <div className={css.Row} ref={row.rowRef}>
        <SelectComponent
          parentRef={row.rowRef}
          label="Приоритет scroll"
          access={3}
          items={[
            {
              value: 1,
              name: 'Низкий',
            },
            {
              value: 2,
              name: 'Нормальный',
            },
            {
              value: 3,
              name: 'Высокий',
            },
            {
              value: 4,
              name: 'Очень очень очень высокий прям критикал супер важная задача asap',
            },
            {
              value: 12,
              name: 'Низкий',
            },
            {
              value: 22,
              name: 'Нормальный',
            },
            {
              value: 32,
              name: 'Высокий',
            },
            {
              value: 42,
              name: 'Очень очень очень высокий прям критикал супер важная задача asap',
            },
            {
              value: 13,
              name: 'Низкий',
            },
            {
              value: 23,
              name: 'Нормальный',
            },
            {
              value: 33,
              name: 'Высокий',
            },
            {
              value: 43,
              name: 'Очень очень очень высокий прям критикал супер важная задача asap',
            },
          ]}
          {...row}
        />
      </div>
    </div>
  );
};

export const SelectRenderItemAsUser = () => {
  const row = useRowForSelect();
  return (
    <div className={css.Page}>
      <div className={css.Row} ref={row.rowRef}>
        <SelectComponent
          parentRef={row.rowRef}
          label="Render user"
          access={3}
          getName={(item = {}) => (item as SuggestUser).name}
          getValue={(item) => (item as SuggestUser).id}
          renderItem={({ item, isSelected, group, border, onClick }) => (
            <User
              user={item as SuggestUser}
              checked={isSelected}
              group={group}
              border={border}
              onClick={onClick}
            />
          )}
          items={[
            {
              id: 1,
              name: 'ilya',
            },
            {
              id: 2,
              name: 'masha',
            },
            {
              id: 3,
              name: 'vova',
            },
            {
              id: 4,
              name: 'misha',
            },
          ]}
          {...row}
        />
      </div>
    </div>
  );
};

const SelectProps = ({ label, access, items, size }) => {
  const row = useRowForSelect();
  const knobsProps = {
    label,
    access,
    items,
    size,
  };

  return (
    <div className={css.Page}>
      <div className={css.Row} ref={row.rowRef}>
        <SelectComponent parentRef={row.rowRef} {...knobsProps} {...row} />
      </div>
    </div>
  );
};

SelectProps.args = {
  label: 'Label',
  access: 3,
  items: [
    {
      value: 1,
      name: 'Низкий',
    },
    {
      value: 2,
      name: 'Нормальный',
    },
    {
      value: 3,
      name: 'Высокий',
    },
    {
      value: 4,
      name: 'Очень очень очень высокий прям критикал супер важная задача asap',
    },
  ],
  size: {
    ratio: {
      left: 2,
      right: 4,
    },
    max: {
      left: 40,
    },
  },
};

export { SelectProps };
