import React, { FC, useCallback } from 'react';
import { RenderProps } from 'components/design/ListItem/Group';
import { SuggestUser as ISuggestUser } from 'types/SuggestUser';
import { Suggest } from '../Suggest';
import { User } from '../../../ListItem/User';
import { StaffSuggestProps } from './StaffSuggest.types';

const SuggestUser: FC<RenderProps> = (props) => {
  return (
    <User
      user={props.item as ISuggestUser}
      checked={props.isSelected}
      onClick={props.onClick}
      border={props.border}
      group={props.group}
    />
  );
};

const getValue = (item) => (item as ISuggestUser).id;

export const StaffSuggest: FC<StaffSuggestProps> = (props) => {
  const { getName: outerGetName } = props;

  const getName = useCallback(
    (item) => {
      if (outerGetName) {
        return outerGetName(item);
      }

      return ((item || {}) as ISuggestUser).name;
    },
    [outerGetName],
  );

  return <Suggest {...props} getValue={getValue} getName={getName} renderItem={SuggestUser} />;
};
