import React, { useState, useRef } from 'react';
import { storiesOf } from '@storybook/react';
import { StaffSuggest } from '../StaffSuggest';
import css from './Stories.module.css';
import { SuggestStaffResponse } from './SuggestStaffResponse';

const storiesBlock = storiesOf('design/Attribute/ReadEdit/StaffSuggest', module);

storiesBlock.add('StaffSuggest', () => {
  const [isEditing, setEditing] = useState(false);
  const rowRef = useRef<HTMLDivElement>(null);
  const [text, setText] = useState('');
  const [value, setValue] = useState<number | string>();
  const handleTextChange = (newText: string) => {
    setText(newText);
  };

  const handleChange = (value: number | string) => {
    setValue(value);
  };

  const handleEditingStart = () => {
    setEditing(true);
  };

  const handleEditingStop = () => {
    setEditing(false);
  };

  const mapper = (data: SuggestStaffResponse) => {
    return data.items.map((item) => data.map.users[item.eId]);
  };

  const searchParams = new URLSearchParams({
    text,
    variant: 'UsersOnly',
    onlyUserHadAnyRole: 'true',
    onlyUserActive: 'true',
  }).toString();

  return (
    <div className={css.Page}>
      <div className={css.Row} ref={rowRef}>
        <StaffSuggest
          url={`/suggest/staff?${searchParams}`}
          parentRef={rowRef}
          label="Исполнитель"
          placeholder="Поиск исполнителя"
          size={{
            ratio: {
              left: 1,
              right: 2,
            },
          }}
          debounce={500}
          access={3}
          isEditing={isEditing}
          onEditingStart={handleEditingStart}
          onEditingStop={handleEditingStop}
          value={value}
          onChange={handleChange}
          text={text}
          onTextChange={handleTextChange}
          mapper={mapper}
        />
      </div>
    </div>
  );
});
