import React, { FC, useRef } from 'react';
import { Select as ReadSelect } from '../../Read/Select';
import { Textinput } from '../../Edit/Textinput';
import { SuggestProps } from './Suggest.types';
import { PopupItems } from '../../Edit/PopupItems';
import { defaultGetValue, defaultGetName } from './Suggest.utils';

export const Suggest: FC<SuggestProps> = (props) => {
  const {
    label,
    value = -1,
    isEditing,
    access,
    onEditingStart,
    onEditingStop,
    onChange,
    text = '',
    onTextChange,
    parentRef,
    items,
    renderItem,
    placeholder,
    getValue = defaultGetValue,
    getName = defaultGetName,
    size,
    isReadLoading,
    isEditLoading,
    directions,
  } = props;

  const textinputRef = useRef<HTMLDivElement>(null);

  const toggleEditing = () => {
    if (isEditing) {
      onEditingStop();
    } else {
      onEditingStart();
    }
  };

  const handleChange = (value: number | string) => {
    if (onChange) {
      onChange(value);
      onEditingStop();
    }
  };

  const selectedItem = items.find((item) => getValue(item) === value);
  const previewName = getName(selectedItem);

  if (!isEditing) {
    return (
      <ReadSelect
        label={label}
        value={previewName}
        size={size}
        access={access}
        isLoading={isReadLoading}
        onClick={toggleEditing}
      />
    );
  }

  return (
    <>
      <Textinput
        value={text}
        onChange={onTextChange}
        nodeRef={textinputRef}
        placeholder={placeholder}
      />
      <PopupItems
        value={value}
        items={items}
        onChange={handleChange}
        getValue={getValue}
        renderItem={renderItem}
        parentRef={parentRef}
        isEditing={isEditing}
        isLoading={isEditLoading}
        anchor={textinputRef}
        onClose={onEditingStop}
        directions={directions}
      />
    </>
  );
};
