import { RefObject, ComponentType } from 'react';
import { ComponentCanGroupProps } from 'components/design/ListItem/Group/ComponentCanGroupProps';
import { RenderProps } from 'components/design/ListItem/Group';
import { Direction } from '@crm/components/dist/lego2/withOldDirections';
import { ReadEditProps } from '../../ReadEditProps';

export interface SuggestProps extends ReadEditProps, ComponentCanGroupProps {
  parentRef: RefObject<HTMLElement>;
  items: unknown[];
  renderItem?: ComponentType<RenderProps>;
  getValue?: (item: unknown) => string | number;
  getName?: (item?: unknown) => string;
  placeholder?: string;
  text?: string;
  onTextChange?: (text: string) => void;
  directions?: Direction[];
}
