import React, { ComponentType, useEffect, useState } from 'react';
import { useDebounce } from 'utils/hooks/useDebounce';
import { SuggestProps } from '../../Suggest.types';
import { WrappedComponentProps } from './withLoad.types';

export const withLoad = (
  Suggest: ComponentType<SuggestProps>,
): ComponentType<WrappedComponentProps> => (props) => {
  const { onLoad, debounce: debounceDelay, ...restProps } = props;
  const debouncedText = useDebounce(props.text, debounceDelay);
  const [isLoading, setLoading] = useState(false);
  const [items, setItems] = useState<unknown[]>([]);

  let loadAndSetItems = () => {
    setLoading(true);
    onLoad()
      .then((newItems) => {
        setItems(newItems);
      })
      .finally(() => {
        setLoading(false);
      });
  };

  useEffect(() => {
    if (!props.isEditing) {
      return;
    }

    loadAndSetItems();
  }, [debouncedText, props.isEditing]);

  return <Suggest {...restProps} isEditLoading={isLoading} items={items} />;
};
