import React, { ComponentType } from 'react';
import { baseCallApi } from 'entry/api/common';
import { compose } from 'redux';
import { withLoad, WrappedComponentProps as WithLoadComponentProps } from '../withLoad';
import { WrappedComponentProps } from './withUrlLoad.types';
import { defaultMapper } from './withUrlLoad.utils';
import { DEBOUNCE_DELAY } from './withUrlLoad.constants';

export const handleLoadWithRequest = (
  Suggest: ComponentType<WithLoadComponentProps>,
): ComponentType<WrappedComponentProps> => (props) => {
  const {
    url,
    mapper = defaultMapper,
    debounce = DEBOUNCE_DELAY,
    shareItems,
    ...restProps
  } = props;

  const handleLoad = () => {
    return baseCallApi({
      url,
      data: {
        text: props.text,
      },
      global: false,
    }).then((data) => {
      if (shareItems) {
        shareItems(data.items);
      }
      return mapper(data);
    });
  };

  return <Suggest {...restProps} debounce={debounce} onLoad={handleLoad} />;
};

export const withUrlLoad = compose(handleLoadWithRequest, withLoad);
