import React, { useState, useRef } from 'react';
import { storiesOf } from '@storybook/react';
import { withLoad } from '../hoc/withLoad';
import { Suggest as PureSuggest } from '../Suggest';
import { Option } from '../../Select/Select.types';
import css from './Stories.module.css';

const storiesBlock = storiesOf('design/Attribute/ReadEdit/Suggest', module);

const Suggest = withLoad(PureSuggest);

const useRowForSuggest = (options: { value: number; name: string }[]) => {
  const [isEditing, setEditing] = useState(false);
  const rowRef = useRef<HTMLDivElement>(null);
  const [text, setText] = useState('');
  const [value, setValue] = useState<number | string>();
  const handleTextChange = (newText: string) => {
    setText(newText);
  };

  const handleChange = (value: number | string) => {
    setValue(value);
  };

  const handleEditingStart = () => {
    setEditing(true);
  };

  const handleEditingStop = () => {
    setEditing(false);
  };

  const handleLoad = () => {
    return new Promise((resolve) => {
      setTimeout(() => {
        resolve(
          options.filter((option) => option.name.toLowerCase().indexOf(text.toLowerCase()) !== -1),
        );
      }, 500);
    }) as Promise<Option[]>;
  };

  return {
    isEditing,
    rowRef,
    text,
    value,
    onTextChange: handleTextChange,
    onChange: handleChange,
    onEditingStart: handleEditingStart,
    onEditingStop: handleEditingStop,
    onLoad: handleLoad,
    debounce: 400,
  };
};

storiesBlock.add('Suggest', () => {
  const options0 = [
    {
      value: 1,
      name: 'Низкий',
    },
    {
      value: 2,
      name: 'Нормальный',
    },
    {
      value: 3,
      name: 'Высокий',
    },
    {
      value: 4,
      name: 'Очень очень очень высокий прям критикал супер важная задача asap',
    },
  ];
  const row0 = useRowForSuggest(options0);

  const options1 = [
    {
      value: 1,
      name: 'Низкий',
    },
    {
      value: 2,
      name: 'Нормальный',
    },
    {
      value: 3,
      name: 'Высокий',
    },
    {
      value: 4,
      name: 'Очень очень очень высокий прям критикал супер важная задача asap',
    },
    {
      value: 11,
      name: 'Низкий',
    },
    {
      value: 21,
      name: 'Нормальный',
    },
    {
      value: 31,
      name: 'Высокий',
    },
    {
      value: 41,
      name: 'Очень очень очень высокий прям критикал супер важная задача asap',
    },
    {
      value: 12,
      name: 'Низкий',
    },
    {
      value: 22,
      name: 'Нормальный',
    },
    {
      value: 32,
      name: 'Высокий',
    },
    {
      value: 42,
      name: 'Очень очень очень высокий прям критикал супер важная задача asap',
    },
  ];
  const row1 = useRowForSuggest(options1);

  return (
    <div className={css.Page}>
      <div className={css.Row} ref={row0.rowRef}>
        <Suggest
          parentRef={row0.rowRef}
          label="Приоритет"
          placeholder="Поиск приоритета"
          access={3}
          {...row0}
        />
      </div>
      <div className={css.Row} ref={row1.rowRef}>
        <Suggest
          parentRef={row1.rowRef}
          label="Приоритет"
          placeholder="Поиск приоритета"
          access={3}
          {...row1}
        />
      </div>
    </div>
  );
});
