import React, { FC, useState, useCallback, useEffect } from 'react';
import { Select as ReadSelect } from '../../Read/Select';
import { Textinput as EditTextinput } from '../../Edit/Textinput';
import { TextinputProps } from './Textinput.types';

export const Textinput: FC<TextinputProps> = (props) => {
  const {
    label = '',
    value = '',
    access = 1,
    isReadLoading = false,
    size,
    isEditing = false,
    group,
    border,
    onEditingStop,
    onEditingStart,
    onChange,
    placeholder = 'Введите значение',
  } = props;

  const [text, setText] = useState<string | number | undefined>(value);
  const changeAndClose = useCallback(() => {
    if (onChange && text !== value) {
      onChange(text);
    }
    onEditingStop();
  }, [onChange, onEditingStop, text, value]);

  useEffect(() => {
    setText(value);
  }, [value, isEditing]);

  let previewValue: string | undefined;
  if (typeof value === 'string') {
    previewValue = value;
    if (!value.length) {
      previewValue = undefined;
    }
  }

  if (typeof value === 'number') {
    previewValue = String(value);
  }

  if (!isEditing) {
    return (
      <ReadSelect
        access={access}
        label={label}
        group={group}
        border={border}
        onClick={onEditingStart}
        size={size}
        isLoading={isReadLoading}
        value={previewValue}
        hasCarets={false}
      />
    );
  }

  return (
    <EditTextinput
      value={text}
      placeholder={placeholder}
      onChange={setText}
      onClose={changeAndClose}
      onEnter={changeAndClose}
      border={border}
      group={group}
    />
  );
};
