import React, { useState } from 'react';
import { storiesOf } from '@storybook/react';
import { Group } from 'components/design/ListItem/Group';
import { Textinput } from '../Textinput';
import css from './Stories.module.css';

const storiesBlock = storiesOf('design/Attribute/ReadEdit/Textinput', module);

const withTextinputState = (Component: typeof Textinput) => (props) => {
  const [isEditing, setEditing] = useState(false);
  const [value, setValue] = useState<number | string>(props.value || '');
  const handleChange = (value: number | string) => {
    setValue(value);
  };

  const handleEditingStart = () => {
    setEditing(true);
  };

  const handleEditingStop = () => {
    setEditing(false);
  };

  const stateProps = {
    onEditingStart: handleEditingStart,
    onEditingStop: handleEditingStop,
    onChange: handleChange,
    isEditing,
    value,
  };

  return <Component {...stateProps} {...props} />;
};

const StatefulTextinput = withTextinputState(Textinput);

storiesBlock.add('Textinput', () => {
  return (
    <div className={css.Page}>
      <div className={css.Row}>
        <StatefulTextinput label="Линия" access={3} />
      </div>
      <div className={css.Row}>
        <h4>access = 1</h4>
        <StatefulTextinput label="Линия" access={1} />
      </div>
      <div className={css.Row}>
        <h4>isReadLoading = true</h4>
        <StatefulTextinput label="Линия" access={3} isReadLoading />
      </div>
      <div className={css.Row}>
        <h4>Group</h4>
        <Group
          items={[
            {
              name: 'line',
              label: 'Линия',
              access: 3,
            },
            {
              name: 'type',
              label: 'Тип',
              access: 3,
            },
            {
              name: 'anything else',
              label: 'Бюджет',
              access: 3,
            },
          ]}
          getValue={(item) => (item as { name: string }).name}
          renderItem={({ border, group, item }) => (
            <StatefulTextinput border={border} group={group} {...item} />
          )}
        />
      </div>
    </div>
  );
});
