import React, { useState } from 'react';
import { storiesOf } from '@storybook/react';
import { Audio } from './Audio';
import { useAudioState } from './useAudioState';

const AudioStories = () => {
  const [audio] = useState(
    new window.Audio('https://kdg.htmlweb.ru/music/mark_bernes_-_zhuravli.mp3'),
  );
  const audioState = useAudioState(audio);

  return (
    <>
      <div style={{ marginTop: 50 }} />
      <Audio {...audioState} />
    </>
  );
};

storiesOf('design', module).add('Audio', () => <AudioStories />);
