import React, { FC } from 'react';
import { PlayButton } from './PlayButton';
import { AudioProps } from './Audio.types';
import { RateButton } from './RateButton';
import { TimeTrack } from './TimeTrack';
import css from './Audio.module.css';

export const Audio: FC<AudioProps> = (props) => {
  const {
    isPlaying = false,
    onPlayChange,
    rate = 1,
    onRateChange,
    duration = 0,
    isLoading = false,
    isPlayDisabled = false,
    isRateDisabled = false,
    currentTime = 0,
    onCurrentTimeChange,
    children,
  } = props;

  return (
    <div className={css.Audio}>
      <PlayButton
        isPlaying={isPlaying}
        isDisabled={isPlayDisabled}
        onPlayChange={onPlayChange}
        className={css.Audio__playButton}
      />
      <RateButton
        rate={rate}
        onRateChange={onRateChange}
        isDisabled={!isPlaying || isRateDisabled}
        className={css.Audio__rateButton}
      />
      {children ? (
        children
      ) : (
        <TimeTrack
          currentTime={currentTime}
          onCurrentTimeChange={onCurrentTimeChange}
          duration={duration}
          isLoading={isLoading}
          className={css.Audio__timeTrack}
        />
      )}
    </div>
  );
};
