import React, { FC } from 'react';
import cx from 'classnames';
import { ButtonProps } from './Button.types';
import css from './Button.module.css';

export const Button: FC<ButtonProps> = ({
  isDisabled,
  onClick,
  className: outerClassName,
  children,
}) => {
  const className = cx(css.Button, outerClassName, {
    [css.Button_disabled]: isDisabled,
  });

  const handleClick = () => {
    if (onClick && !isDisabled) {
      onClick();
    }
  };

  return (
    <button disabled={isDisabled} onClick={handleClick} className={className} type="button">
      {children}
    </button>
  );
};
