import React, { FC } from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import { Button } from '../Button';
import { PlayButtonProps } from './PlayButton.types';
import css from './PlayButton.module.css';
import { playIconTestId, pauseIconTestId } from './PlayButton.constants';

export const PlayButton: FC<PlayButtonProps> = ({
  className,
  isPlaying,
  onPlayChange,
  isDisabled,
}) => {
  const handleClick = () => {
    if (onPlayChange) {
      onPlayChange(!isPlaying);
    }
  };

  return (
    <Button onClick={handleClick} className={className} isDisabled={isDisabled}>
      {isPlaying ? (
        <Icon svg="pause" svgSize="l" data-testid={pauseIconTestId} />
      ) : (
        <Icon className={css.PlayButton__playIcon} svg="play" data-testid={playIconTestId} />
      )}
    </Button>
  );
};
