import React, { FC } from 'react';
import cx from 'classnames';
import { Text } from 'components/design/Text';
import { Button } from '../Button';
import { RateButtonProps } from './RateButton.types';
import { MIN_PLAYBACK_SPEED, MAX_PLAYBACK_SPEED, PLAYBACK_RATE_STEP } from './RateButton.constants';
import css from './RateButton.module.css';

export const RateButton: FC<RateButtonProps> = ({
  rate,
  onRateChange,
  isDisabled = false,
  className,
}) => {
  const handleClick = () => {
    if (onRateChange) {
      const newRate = rate + PLAYBACK_RATE_STEP;
      onRateChange(newRate > MAX_PLAYBACK_SPEED ? MIN_PLAYBACK_SPEED : newRate);
    }
  };

  return (
    <Button className={cx(css.RateButton, className)} onClick={handleClick} isDisabled={isDisabled}>
      <span className={css.RateButton__crossIcon}>&#215;</span>
      <Text className={css.RateButton__rateValue}>{rate}</Text>
    </Button>
  );
};
