import React, { FC } from 'react';
import cx from 'classnames';
import { StepProps } from './Step.types';
import css from './Step.module.css';

export const Step: FC<StepProps> = (props) => {
  const { state, style } = props;
  const className = cx(css.Step, props.className, {
    [css.Step_played]: state === 'played',
    [css.Step_hovered]: state === 'hovered',
  });
  return <div className={className} style={style} />;
};
