import React, { FC } from 'react';
import Popup from '@crm/components/dist/lego2/Popup';
import { FormattedDate } from 'react-intl';
import { TimeTooltipProps } from './TimeTooltip.types';
import css from './TimeTooltip.module.css';

export const TimeTooltip: FC<TimeTooltipProps> = (props) => {
  const { scope, anchor, isVisible, time, horizontalOffset } = props;

  return (
    <Popup
      className={css.TimeTooltip}
      visible={isVisible}
      hasTail
      view="default"
      keepMounted
      scope={scope}
      target="anchor"
      anchor={anchor}
      secondaryOffset={horizontalOffset}
      direction={['top-start', 'bottom-start']}
    >
      <FormattedDate minute="numeric" second="numeric" value={new Date(time * 1000)} />
    </Popup>
  );
};
