import React, { FC } from 'react';
import cx from 'classnames';
import { FormattedDate } from 'react-intl';
import { Text } from 'components/design/Text';
import { TimeTextProps } from './TimeText.types';
import css from './TimeText.module.css';

export const TimeText: FC<TimeTextProps> = (props) => {
  const { currentTime = 0 } = props;
  const duration = isNaN(props.duration) ? 0 : props.duration;

  const text = (
    <>
      <FormattedDate minute="numeric" second="numeric" value={new Date(currentTime * 1000)} />
      &nbsp;/&nbsp;
      <FormattedDate minute="numeric" second="numeric" value={new Date(duration * 1000)} />
    </>
  );

  const className = cx(css.TimeText, props.className);

  return <Text className={className}>{(text as unknown) as string}</Text>;
};
