import React, { FC } from 'react';
import cx from 'classnames';
import Spin from '@crm/components/dist/lego2/Spin';
import { TimeText } from './TimeText';
import { Steps } from './Steps';
import { TimeTrackProps } from './TimeTrack.types';
import css from './TimeTrack.module.css';

export const TimeTrack: FC<TimeTrackProps> = (props) => {
  const {
    duration = 0,
    isLoading = false,
    currentTime = 0,
    onCurrentTimeChange,
    className,
  } = props;

  return (
    <div className={cx(css.TimeTrack, className)}>
      {isLoading && (
        <div className={css.TimeTrack__spinWrap}>
          <Spin view="default" progress size="xxs" />
        </div>
      )}
      {!isLoading && (
        <Steps
          currentTime={currentTime}
          duration={duration}
          onCurrentTimeChange={onCurrentTimeChange}
        />
      )}
      <TimeText currentTime={currentTime} duration={duration} />
    </div>
  );
};
