import React, { FC, CSSProperties } from 'react';
import cx from 'classnames';
import Icon from '@crm/components/dist/lego2/Icon';
import { CheckboxProps } from './Checkbox.types';
import css from './Checkbox.module.css';

export const Checkbox: FC<CheckboxProps> = (props) => {
  const {
    className: outerClassName,
    checked = false,
    onChange,
    color = 'rgb(19, 19, 18)',
    ...restProps
  } = props;

  const handleClick = () => {
    if (onChange) {
      onChange(!checked);
    }
  };

  const className = cx(css.Checkbox, outerClassName);
  const boxStyle: CSSProperties = {
    borderColor: color,
  };
  const style: CSSProperties = {
    color,
  };

  return (
    <div
      className={className}
      onClick={handleClick}
      style={style}
      role="checkbox"
      aria-checked={checked}
      {...restProps}
    >
      <div className={css.Checkbox__box} style={boxStyle} />
      {checked && <Icon svg="check2" className={css.Checkbox__icon} />}
    </div>
  );
};
