import React, { useState, useRef } from 'react';
import { storiesOf } from '@storybook/react';
import { Group } from 'components/design/ListItem/Group';
import { Filter } from '../Filter';
import css from './Stories.module.css';

const storiesBlock = storiesOf('design/Filter', module);

const useFilterState = () => {
  const clickCount = useRef(0);
  const [isDisabled, setDisabled] = useState(false);
  const [isPressed, setPressed] = useState(false);
  const [isExpanded, setExpanded] = useState(false);

  const handleExpand = () => {
    setExpanded((prev) => !prev);
  };

  const handleClick = () => {
    setPressed((prev) => !prev);
    clickCount.current++;
    if (!(clickCount.current % 4)) {
      setDisabled((prev) => !prev);
    }
  };

  return {
    isDisabled,
    isPressed,
    isExpanded,
    onExpand: handleExpand,
    onClick: handleClick,
  };
};

storiesBlock.add('Filter', () => {
  const state0 = useFilterState();
  const state1 = useFilterState();
  const state2 = useFilterState();
  const state3 = useFilterState();
  const state4 = useFilterState();

  const items = [
    {
      id: 1,
      label: 'Первый фильтр',
      counter: 5,
      canExpand: true,
    },
    {
      id: 2,
      label: 'Второй фильтр',
      counter: 2,
      depth: 2,
    },
    {
      id: 3,
      label: 'Третий фильтр',
      counter: 7,
    },
  ];

  return (
    <div className={css.Page}>
      <div className={css.Row}>
        <Filter label="Сегодня" value={3} canExpand {...state0} />
        <Filter label="Завтра" value={377} depth={2} canExpand {...state1} />
        <Filter label="Завтра" value={377} depth={3} {...state2} />
        <Filter label="Завтра" value={377} depth={3} {...state3} isDisabled />
        <Filter
          label="Lorem ipsum dolor, sit amet consectetur adipisicing elit"
          value={377}
          depth={2}
          {...state4}
        />
      </div>

      <div className={css.Row}>
        <h3>Компонент ListItem/Group</h3>
        <Group
          items={items}
          renderItem={({ item, group, border }) => {
            const filter = item as {
              id: number;
              label: string;
              counter: number;
              canExpand?: boolean;
              depth?: number;
            };

            return (
              <Filter
                label={filter.label}
                value={filter.counter}
                canExpand={filter.canExpand}
                depth={filter.depth}
                border={border}
                group={group}
              />
            );
          }}
        />
      </div>
    </div>
  );
});
