import React, { FC, CSSProperties } from 'react';
import cx from 'classnames';
import { BoxProps } from './Box.types';
import { createClassName } from './Box.utils';
import { LeftRight } from '../LeftRight';
import { groupClassName } from '../groupClassName';
import css from './Box.module.css';

export const Box: FC<BoxProps> = (props) => {
  const {
    className: outerClassName,
    view,
    border,
    group,
    cursor,
    nodeRef,
    left,
    right,
    size,
    style: outerStyle,
    ...restProps
  } = props;
  const className = createClassName(props);
  const style: CSSProperties = {
    ...outerStyle,
    cursor,
  };

  let content = props.children;
  if (left || right) {
    content = (
      <LeftRight
        className={css.Box__leftRight}
        left={left ? left(css.Box__leftPart) : null}
        right={right ? right(css.Box__rightPart) : null}
        size={size}
      />
    );
  }

  return (
    <div
      className={cx(className, groupClassName(group))}
      style={style}
      ref={nodeRef}
      {...restProps}
    >
      {content}
    </div>
  );
};
