import { HTMLAttributes, RefObject, ReactNode } from 'react';
import { LeftRightSize } from '../LeftRight/LeftRight.types';

export type BackgroundType =
  | 'white'
  | 'lightGray'
  | 'mediumGray'
  | 'lightRed'
  | 'blue'
  | 'mediumRed';

export type BorderType = 'none' | 'bottom' | 'bottom-margin' | 'focus' | 'input';

export type CursorType = 'pointer' | 'default';

export type GroupType =
  | 'round-round'
  | 'round-brick'
  | 'clear-brick'
  | 'clear-round'
  | 'top-scroll'
  | 'bottom-scroll';

export type ViewType = 'default';

export interface BoxProps extends HTMLAttributes<HTMLDivElement> {
  view?: ViewType;
  group?: GroupType;
  border?: BorderType;
  cursor?: CursorType;
  left?: (className: string) => ReactNode;
  right?: (className: string) => ReactNode;
  size?: LeftRightSize;
  nodeRef?: RefObject<HTMLDivElement> | ((node: HTMLDivElement) => void);
}
