import cx from 'classnames';
import { BoxProps } from './Box.types';
import css from './Box.module.css';

export const createClassName = (props: BoxProps): string => {
  const { view = 'default', border = 'none', left, right, className } = props;

  let result: string = cx(css.Box, className, {
    [css.Box_view_default]: view === 'default',
    [css.Box_hasPadding]: left == null && right == null,
  });

  if (border != null && !Array.isArray(border)) {
    result = cx(result, css[`Box_border_${border}`]);
  }

  return result;
};
