import React from 'react';
import cx from 'classnames';
import { storiesOf } from '@storybook/react';
import { Box } from '../Box';
import { Text } from '../../../Text';
import css from './Stories.module.css';

const storiesBlock = storiesOf('design/Box', module);

storiesBlock.add('Box', () => (
  <div className={css.Page}>
    <div className={css.PropExamples}>
      <h3>props.border</h3>
      <Box border="none">border: none</Box>
      <Box border="bottom">border: bottom</Box>
      <Box border="bottom-margin">border: bottom-margin</Box>
      <Box border="input">border: input</Box>
      <Box border="focus">border: focus</Box>
    </div>
    <div className={css.PropExamples}>
      <h3>props.cursor</h3>
      <Box cursor="default">cursor: default</Box>
      <Box cursor="pointer">cursor: pointer</Box>
    </div>
    <div className={cx(css.PropExamples, css.GroupProps)}>
      <h3>props.group</h3>
      <Box group="round-brick" border="bottom-margin">
        group: round-brick
      </Box>
      <Box group="clear-brick" border="bottom-margin">
        group: clear-brick
      </Box>
      <Box group="clear-round" border="none">
        group: clear-round
      </Box>
      <br />
      <Box group="round-round">group: round-round</Box>
    </div>
    <div className={css.PropExamples}>
      <Box
        left={(cls) => (
          <Text className={cls} overflow="visible">
            Left
          </Text>
        )}
        right={(cls) => (
          <Text className={cls} overflow="hidden">
            Right
          </Text>
        )}
      />
    </div>
  </div>
));
