import React, { FC } from 'react';
import cx from 'classnames';
import { Text } from '../../Text';
import { CaptionProps } from './Caption.types';
import css from './Caption.module.css';

export const Caption: FC<CaptionProps> = (props) => {
  const { oveflow = 'hidden' } = props;
  const className = cx(css.Caption, props.className);

  return (
    <Text overflow={oveflow} className={className}>
      {props.children}
    </Text>
  );
};
