import React, { FC, CSSProperties } from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import cx from 'classnames';
import { ChevronProps } from './Chevron.types';
import css from './Chevron.module.css';

export const Chevron: FC<ChevronProps> = (props) => {
  const { direction = 'right', color } = props;

  const className = cx(props.className, css.Chevron, css[`Chevron_direction_${direction}`]);
  const style: CSSProperties = {
    color,
  };

  return <Icon className={className} style={style} svg="chevron" svgSize="s" />;
};
