import React, { FC, useState, useEffect, CSSProperties, useRef } from 'react';
import { useVerticalScroll } from 'utils/hooks/useVerticalScroll';
import { useNonPassiveWheel } from 'utils/hooks/useNonPassiveWheel';
import { Option } from 'components/design/Attribute/Edit/PopupItems/Option';
import { GroupProps } from './Group.types';
import css from './Group.module.css';
import { defaultGetValue, computeStyle, isScrollable } from './Group.utils';
import { ColumnDirection } from '../ColumnDirection';
import { ItemsList } from './ItemsList';

export const Group: FC<GroupProps> = (props) => {
  const {
    items,
    renderItem = Option,
    getValue = defaultGetValue,
    isFocused = false,
    value,
    onChange,
  } = props;
  const nodeRef = useRef<HTMLDivElement>(null);
  const [columnNode, setColumnNode] = useState<HTMLDivElement | null>(null);
  const [style, setStyle] = useState<CSSProperties>();
  const handleWheel = useVerticalScroll(columnNode);
  useNonPassiveWheel(nodeRef.current, handleWheel);

  const isColumnScrollable = isScrollable(columnNode);

  useEffect(() => {
    setStyle(
      computeStyle({ isScrollable: isColumnScrollable, scrollbarWidth: window.scrollBarWidth }),
    );
  }, [items, columnNode, isColumnScrollable]);

  return (
    <div className={css.Group} style={style} ref={nodeRef}>
      <ColumnDirection className={css.Group__column} nodeRef={setColumnNode}>
        <ItemsList
          isScrollable={isColumnScrollable}
          scrollNode={columnNode}
          items={items}
          renderItem={renderItem}
          getValue={getValue}
          isFocused={isFocused}
          value={value}
          onChange={onChange}
        />
      </ColumnDirection>
    </div>
  );
};
