import { types } from 'components/design/ListItem/Box';
import { ComponentType } from 'react';

export interface RenderProps<T = unknown> {
  item: T;
  group?: types.GroupType;
  border?: types.BorderType | undefined;
  isHovered?: boolean;
  isSelected?: boolean;
  onClick?: () => void;
  onMouseEnter?: () => void;
  onMouseLeave?: () => void;
}

export interface GroupProps {
  items: unknown[];

  // TODO: подумать как тут лучше структурировать файлы компонентов
  // Более общий компонент не должен зависеть от контрола
  /**
   * По умолчанию Option из Attribute/PopupItems
   */
  renderItem?: ComponentType<RenderProps>;

  /**
   * По умолчанию пытается взять item.id
   */
  getValue?: (item: unknown) => number | string;

  /**
   * Обязателен для правильного поведения клавиатурной навигации
   */
  isFocused?: boolean;

  value?: number | string;

  onChange?: (item: unknown) => void;
}
