import { types } from 'components/design/ListItem/Box';
import { CSSProperties } from 'react';
import { LISTITEM_BORDER_RADIUS } from './Group.constants';

export const computeGroup = (payload: {
  length: number;
  index: number;
  isScrollable?: boolean;
}): types.GroupType => {
  const { length, index, isScrollable = false } = payload;

  if (length === 1) {
    return 'round-round';
  }

  if (index === 0) {
    if (isScrollable) {
      return 'top-scroll';
    }

    return 'round-brick';
  }

  if (index === length - 1) {
    if (isScrollable) {
      return 'bottom-scroll';
    }

    return 'clear-round';
  }

  return 'clear-brick';
};

export const computeBorder = (payload: {
  length: number;
  index: number;
}): types.BorderType | undefined => {
  const { length, index } = payload;

  if (index === length - 1) {
    return 'none';
  }
};

export const computeStyle = (payload: {
  scrollbarWidth: number;
  isScrollable: boolean;
}): CSSProperties => {
  const { isScrollable, scrollbarWidth = LISTITEM_BORDER_RADIUS } = payload;

  if (isScrollable) {
    return {
      paddingRight: `${scrollbarWidth - LISTITEM_BORDER_RADIUS}px`,
    };
  }

  return {};
};

export const isScrollable = (node: HTMLElement | null): boolean => {
  let isScrollable = false;
  if (node) {
    isScrollable = node.scrollHeight > node.clientHeight;
  }

  return isScrollable;
};

interface HasId {
  id?: number | string;
}
const hasId = (something: unknown): something is HasId => {
  return typeof something === 'object' && something != null && 'id' in something;
};

export const defaultGetValue = (something: unknown): string | number | undefined => {
  if (hasId(something)) {
    return something.id;
  }
};
