export const scrollToChildIndex = (scrollNode: HTMLElement | null, index: number) => {
  if (scrollNode === null) {
    return;
  }

  const child = scrollNode.children[index] as HTMLElement;
  if (!child) {
    return;
  }

  const scrollNodeOffsetTop = scrollNode.getBoundingClientRect().top;
  const childOffsetTop = child.getBoundingClientRect().top;
  let relativeScroll = 0;
  if (childOffsetTop < scrollNodeOffsetTop) {
    relativeScroll = childOffsetTop - scrollNodeOffsetTop;
  } else {
    relativeScroll =
      childOffsetTop + child.offsetHeight - scrollNodeOffsetTop - scrollNode.offsetHeight;
    if (relativeScroll < 0) {
      relativeScroll = 0;
    }
  }
  scrollNode.scrollTop = scrollNode.scrollTop + relativeScroll;
};
