import React, { FC, useState, RefObject, useRef } from 'react';
import { storiesOf } from '@storybook/react';
import { Option } from 'components/design/Attribute/ReadEdit/Select/Select.types';
import { Group } from '../Group';
import css from './Stories.module.css';
import { Select } from '../../../Attribute/ReadEdit/Select';
import { User } from '../../User';
import { GroupType, BorderType } from '../../Box/Box.types';

const storiesBlock = storiesOf('design/Group', module);

const StatefulSelect: FC<{
  parentRef: RefObject<HTMLElement>;
  label: string;
  options: Option[];
  group: GroupType;
  border: BorderType;
  access: number;
  isLoading: boolean;
}> = (props) => {
  const [isEditing, setEditing] = useState(false);
  const [value, setValue] = useState<number | string>();
  const handleChange = (value: number | string) => {
    setValue(value);
  };

  const handleEditingStart = () => {
    setEditing(true);
  };

  const handleEditingStop = () => {
    setEditing(false);
  };

  return (
    <Select
      parentRef={props.parentRef}
      label={props.label}
      access={props.access}
      items={props.options}
      value={value}
      onChange={handleChange}
      isEditing={isEditing}
      isReadLoading={props.isLoading}
      onEditingStart={handleEditingStart}
      onEditingStop={handleEditingStop}
      group={props.group}
      border={props.border}
    />
  );
};

storiesBlock.add('Group', () => {
  const attributesRowRef = useRef<HTMLDivElement>(null);
  const attributes = [
    {
      id: 1,
      label: 'Наблюдатели',
      options: [
        {
          value: 1,
          name: 'Петя',
        },
        {
          value: 2,
          name: 'Вася',
        },
        {
          value: 3,
          name: 'Вова',
        },
      ],
      access: 3,
    },
    {
      id: 2,
      label: 'Исполнитель',
      options: [
        {
          value: 1,
          name: 'Петя',
        },
        {
          value: 2,
          name: 'Вася',
        },
        {
          value: 3,
          name: 'Вова',
        },
      ],
      value: 3,
      isLoading: true,
      access: 3,
    },
    {
      id: 3,
      label: 'Тип',
      options: [
        {
          value: 1,
          name: 'Задача',
        },
        {
          value: 2,
          name: 'Ошибка',
        },
      ],
      value: 1,
      access: 3,
    },
  ];
  const renderAttribute = ({ item, group, border }) => (
    <StatefulSelect
      parentRef={attributesRowRef}
      options={item.options}
      label={item.label}
      group={group}
      isLoading={item.isLoading}
      access={item.access}
      border={border}
    />
  );

  const users = [
    {
      id: 1,
      login: 'ya',
      name: 'Я',
    },
    {
      id: 2,
      name: 'Иван Большаков',
      login: 'Группа информационной безопасности',
    },
    {
      id: 3,
      name: 'Аминат Исакова',
      login: 'Группа сопровождения РСЯ (Поддержка чего-то там)',
    },
  ];
  const renderUser = ({ item, group, border }) => (
    <User user={item} group={group} border={border} />
  );

  return (
    <div className={css.Page}>
      <div className={css.Row} ref={attributesRowRef}>
        <h3>Атрибуты</h3>
        <Group items={attributes.slice(0, 1)} renderItem={renderAttribute} />
        <br />
        <Group items={attributes.slice(0, 2)} renderItem={renderAttribute} />
        <br />
        <Group items={attributes} renderItem={renderAttribute} />
      </div>
      <div className={css.Row}>
        <h3>Пользователи</h3>
        <Group items={users.slice(0, 1)} renderItem={renderUser} />
        <br />
        <Group items={users.slice(0, 2)} renderItem={renderUser} />
        <br />
        <Group items={users} renderItem={renderUser} />
      </div>
    </div>
  );
});
