import React, { FC, useMemo } from 'react';
import cx from 'classnames';
import { DEFAULT_SIZE } from './LeftRight.constants';
import { LeftRightProps } from './LeftRight.types';
import { sizeToStyles } from './LeftRight.utils';
import css from './LeftRight.module.css';

export const LeftRight: FC<LeftRightProps> = (props) => {
  const { left, right, size = DEFAULT_SIZE } = props;

  const { left: leftStyle, right: rightStyle } = useMemo(() => sizeToStyles(size), [size]);
  const className = cx(css.LeftRight, props.className);

  return (
    <div className={className}>
      <div aria-label="left" className={css.LeftRight__left} style={leftStyle}>
        {left}
      </div>
      <div aria-label="right" className={css.LeftRight__right} style={rightStyle}>
        {right}
      </div>
    </div>
  );
};
