import { CSSProperties } from 'react';
import { Parts, LeftRightSize } from './LeftRight.types';
import { MARGIN_IN_PERCENTS, MAX_PERCENTAGE, DEFAULT_SIZE_RATIO } from './LeftRight.constants';

export const sizeRatioPercents = (
  ratio: Parts<number> = DEFAULT_SIZE_RATIO,
): Required<Parts<number>> => {
  let left = ratio.left ?? (DEFAULT_SIZE_RATIO.left as number);
  let right = ratio.right ?? (DEFAULT_SIZE_RATIO.right as number);
  const sum = left + right;
  if (sum === 0) {
    return {
      left: 0,
      right: 0,
    };
  }

  return {
    left: (left / sum) * MAX_PERCENTAGE,
    right: (right / sum) * MAX_PERCENTAGE,
  };
};

export const sizeToStyles = ({ ratio, max }: LeftRightSize): Parts<CSSProperties> => {
  const sizePercents = sizeRatioPercents(ratio);
  let subtractionAmount = MARGIN_IN_PERCENTS / 2;
  let marginRight = MARGIN_IN_PERCENTS;
  if (sizePercents.left === 0 || sizePercents.right === 0) {
    subtractionAmount = 0;
    marginRight = 0;
  }

  const leftPercent = sizePercents.left - subtractionAmount;
  const rightPercent = sizePercents.right - subtractionAmount;

  const leftStyle: CSSProperties = {
    flexBasis: `${leftPercent}%`,
    marginRight: `${marginRight}%`,
  };

  const rightStyle: CSSProperties = {
    maxWidth: `${rightPercent}%`,
    flexBasis: `${rightPercent}%`,
  };

  if (max && max.left != null) {
    rightStyle.maxWidth = `calc(100% - ${max.left}px)`;
    rightStyle.flexBasis = `calc(100% - ${max.left}px)`;
    leftStyle.maxWidth = `${max.left}px`;
  }

  if (max && max.right != null) {
    leftStyle.flexBasis = `calc(100% - ${max.right}px)`;
    rightStyle.maxWidth = `${max.right}px`;
  }

  return {
    left: leftStyle,
    right: rightStyle,
  };
};
