import React from 'react';
import { LeftRight as LeftRightComponent } from '../LeftRight';
import { Text } from '../../../Text';
import css from './Stories.module.css';

export default {
  title: 'design/LeftRight',
  component: module,
};

export const LeftRight = () => (
  <div className={css.Page}>
    <div className={css.Row}>
      <LeftRightComponent
        left={<Text overflow="hidden">Обрезаемый текст с использованием Text компонента</Text>}
        right={<Text overflow="hidden">Обрезаемое значение</Text>}
      />
    </div>
    <div className={css.Row}>
      <LeftRightComponent
        left={<Text overflow="hidden">Обрезаемый текст с очень большим количеством символов</Text>}
        right={<Text overflow="visible">Необрезаемое значение и большое количество символов</Text>}
      />
    </div>
    <div className={css.Row}>
      <LeftRightComponent
        left={
          <Text overflow="visible">Необрезаемый текст с очень большим количеством символов</Text>
        }
        right={<Text overflow="hidden">Обрезаемое значение</Text>}
      />
    </div>
    <div className={css.Row}>
      <LeftRightComponent
        left={
          <Text overflow="visible">Необрезаемый текст с очень большим количеством символов</Text>
        }
        right={<Text overflow="visible">Необрезаемое значение и еще символы</Text>}
      />
    </div>
  </div>
);

const LeftRightSize = ({ size, ['left text']: leftText, ['right text']: rightText }) => {
  return (
    <div className={css.Page}>
      <div className={css.Row}>
        <LeftRightComponent
          size={size}
          left={<Text overflow="hidden">{leftText}</Text>}
          right={<Text overflow="hidden">{rightText}</Text>}
        />
      </div>
    </div>
  );
};

LeftRightSize.args = {
  size: {
    ratio: {
      left: 1,
      right: 1,
    },
    max: {
      left: 140,
      right: 70,
    },
  },
  'left text': 'Обрезаемый текст с очень большим количеством символов',
  'right text': 'Обрезаемое значение и еще символы',
};

export { LeftRightSize };
