import React, { FC } from 'react';
import cx from 'classnames';
import LegoPopup from '@crm/components/dist/lego2/Popup';
import { PopupProps } from './Popup.types';
import css from './Popup.module.css';

export const Popup: FC<PopupProps> = (props) => {
  const { children, ...restProps } = props;

  return (
    <LegoPopup
      view="default"
      target="anchor"
      role="dialog"
      {...restProps}
      className={cx(css.Popup, props.className)}
    >
      {children}
    </LegoPopup>
  );
};
