import React, { FC } from 'react';
import Spin from '@crm/components/dist/lego2/Spin';
import { Overlay } from 'components/Overlay';
import { TextOverlayProps } from './TextOverlay.types';
import { DEFAULT_TEXT } from './TextOverlay.constants';
import css from './TextOverlay.module.css';

export const TextOverlay: FC<TextOverlayProps> = (props) => {
  const { display = false, className, children = DEFAULT_TEXT } = props;

  return (
    <Overlay
      className={className}
      display={display}
      hasSpinner={false}
      color="rgba(255, 255, 255, .8)"
    >
      <div className={css.TextWrap}>
        {children}
        <Spin className={css.TextWrap__spin} progress view="default" size="xs" />
      </div>
    </Overlay>
  );
};
