import React, { FC, useState } from 'react';
import cx from 'classnames';
import Avatar from 'components/Avatar';
import { Box } from '../Box';
import { UserProps } from './User.types';
import { LeftRight } from '../LeftRight';
import { ColumnDirection } from '../ColumnDirection';
import { Text } from '../../Text';
import { Caption } from '../Caption';
import { Check } from '../Check';
import css from './User.module.css';
import { LeftRightSize } from '../LeftRight/LeftRight.types';

const size: LeftRightSize = {
  ratio: {
    left: 6,
    right: 1,
  },
};
export const User: FC<UserProps> = (props) => {
  const { group, border = 'bottom-margin', user, checked = false, onClick } = props;
  const [isHovering, setHovering] = useState(false);

  const className = cx(css.User, {
    [css.User_hovered]: isHovering,
  });

  const handleClick = () => {
    if (onClick) {
      onClick(user);
    }
  };

  const handleMouseEnter = () => {
    setHovering(true);
  };

  const handleMouseLeave = () => {
    setHovering(false);
  };

  return (
    <Box
      className={className}
      group={group}
      border={border}
      cursor="pointer"
      onMouseEnter={handleMouseEnter}
      onMouseLeave={handleMouseLeave}
      onClick={handleClick}
    >
      <LeftRight
        size={size}
        left={
          <div className={css.User__leftPart}>
            <Avatar className={css.User__avatar} user={user} size="xs" />
            <ColumnDirection>
              <Text overflow="hidden">{user.name}</Text>
              <Caption>{user.login}</Caption>
            </ColumnDirection>
          </div>
        }
        right={checked && <Text align="end" icon={(cls) => <Check className={cls} />} />}
      />
    </Box>
  );
};
