import React, { useState } from 'react';
import { storiesOf } from '@storybook/react';
import { User } from '../User';
import css from './Stories.module.css';

const storiesBlock = storiesOf('design/User', module);

storiesBlock.add('User', () => {
  const [checked, setChecked] = useState(false);

  const handleClick = () => {
    setChecked((prevChecked) => !prevChecked);
  };

  return (
    <div className={css.Page}>
      <div className={css.Row}>
        <User
          checked={checked}
          onClick={handleClick}
          user={{
            id: 1,
            login: 'Группа сопровождения РСЯ (Поддержка чего-то длинного)',
            name: 'Илья',
          }}
        />
      </div>
    </div>
  );
});
